#ifdef WIN32

#ifndef MEETINGMGRCONTROLLERIMPL_H
#define MEETINGMGRCONTROLLERIMPL_H

#include "csfunified/framework/UnifiedFactory.h"
#include "JMMeetingMgr.h"
#include "JMInstantMeeting.h"

#include "csfunified/services/interface/MeetingCallback.h"
#include "csfunified/services/impl/base/MeetingMgrControllerBaseImpl.h"
#include "../JabberServiceProvider.h"

#include "services/impl/base/MeetingReminderInfoBaseImpl.h"
#include "services/impl/base/MeetingIMAlertItemObjectBaseImpl.h"

#include "services/impl/base/MeetingTimeBaseImpl.h"

#include "services/impl/cmr/CMRControllerDef.h"

#include <csf/RWLock.hpp>

namespace CSFUnified
{
    class MeetingCallback;
	class InstantMeetingCallback;
	class MeetingMgrControllerImpl : 
		public MeetingMgrControllerBaseImpl,
		public JabberMeeting::JMMeetingMgrHandler,
		public IInstantMeetingEvent,
		public SMART_PTR_NS::enable_shared_from_this<MeetingMgrControllerImpl>
    {
    public:
		MeetingMgrControllerImpl(SMART_PTR_NS::shared_ptr<UnifiedFactory> unifiedFactory);
        
        ~MeetingMgrControllerImpl()
        {
        }
        
		static MeetingMgrControllerImpl * getInstance()
		{
			static MeetingMgrControllerImpl * s_mmController = NULL;
			if (NULL == s_mmController)
			{
				s_mmController = new MeetingMgrControllerImpl(JabberServiceProvider::getInstance().getUnifiedFactory());
			}

			return s_mmController;
		}

		virtual bool getOnlineSwitch();

		virtual bool getOfflineSwitch();

		void start();

		void stop();

		virtual void registerMeetingCallback(SMART_PTR_NS::shared_ptr<CSFUnified::MeetingCallback> meetingCallback);

		virtual void unregisterMeetingCallback(SMART_PTR_NS::shared_ptr<CSFUnified::MeetingCallback> meetingCallback);

        virtual bool isMeetingInProgress(std::string meetingID);
        
		virtual void getCMRInfo(std::string meetingKeyList);

		virtual unsigned long listMeetings(int year, int month, int day);

		virtual unsigned long refreshMeetings();

		virtual bool todayChanged(bool bForceChanged);

		virtual unsigned long getMeetingDetail(std::string strEventID);

		virtual unsigned long viewMeetingById(std::string strMeetingID);

		virtual unsigned long launchMeetingById(std::string strEventID);

		virtual MailServiceTypeEnum::MailServiceType getCurrentMailType();

		virtual unsigned long sendEmail(std::string strSubject, std::string strTos, std::string strBody, std::string strMeetingKey);
        
		virtual std::string sendMeetingInvitation(std::string attendees, std::string meetingID, std::string msg) { return ""; }
		virtual void setMeetingReminderEnable(bool isEnable) {}
		virtual std::string sendMeetingReminder(std::string attendees, std::string meetingID, std::string msg) { return ""; }

		virtual void startCMRMeeting(bool isAutoStart);
		virtual void joinCMRMeeting(std::string siteUrl, std::string meetingKey, std::string mkgtk);

		// Instant Meeting method
		virtual bool isInMeeting();
		virtual bool canStartMeeting();
		virtual bool canJoinMeeting();
		virtual bool startInstantMeeting(std::string meetingName, SMART_PTR_NS::shared_ptr<std::vector<std::string> > vecInviteList);
		virtual bool inviteToInstantMeeting(std::string attendeeName);
		virtual bool acceptInstantMeeting(std::string sessioName);
		virtual bool declineInstantMeeting(std::string sessioName);
		virtual int getInstantMeetingLastErrCode();
		virtual void editInstantMeetingSetting();
		virtual bool openMeetingDetailPage(std::string strURL);
		virtual bool startJoinMeetingByUrl(std::string strURL);

		// JMMeetingMgrHandler method
		void OnListOneDayEvents(std::wstring const& strEvents);
		void OnOvernight(JabberMeeting::MeetingMgrErrorCode eRet);
		void OnGetWbxMeetingDetail(std::wstring const& strEventXML, std::wstring const& strMeetingDetail);
		void OnInitializeOIFailed();
		void OnInitializeResult(LONG const &lResult);
		void OnMeetingStart(std::wstring const& strEventID, std::wstring const& strMeetingKey);
		void OnMeetingEnd(std::wstring const& strEventID, std::wstring const& strMeetingKey);
		void OnMeetingReminderHappened(JabberMeeting::MeetingReminderItem const& objMeetingReminderItem);
		void OnMeetingReminderEnded(std::wstring const & strEventID);
		void OnMeetingIMAlertHappened(JabberMeeting::MeetingIMAlertItem const &obj);
		void OnGetCMRInfo(const std::wstring& cmrInfo);

		// IInstantMeetingEvent method

		virtual void OnMeetingStart(std::wstring const& strMeetingKey, std::wstring const& strSessionName, BOOL bHost);
		virtual void OnMeetingError(std::wstring const& strMeetingKey, std::wstring const& strSessionName, BOOL bHost);
		virtual void OnMeetingEnd(std::wstring const& strMeetingKey, std::wstring const& strSessionName, BOOL vbHost);
		virtual void OnMeetingInvitation(std::wstring const& strSessionName);
		virtual void OnMeetingCancelInvitation(std::wstring const& strSessionName);
		virtual void OnMeetingDecline(std::wstring const& strSessionName, std::wstring const& strBuddyName);
		virtual void OnPopupWaitDialog();
		virtual void OnCloseWaitDialog();
		virtual void OnShowErrorDialog(int nErrorCode);
		virtual void OnGetShortJoinURL(std::wstring const& pszSiteURL, std::wstring const& strEventID, std::wstring const& pszMeetingKey, std::wstring const& pszShortJoinURL, int eSenario) {}

		virtual void OnCMRMeetingStarted(const CMR_MeetingData & info);
		virtual void OnCMRMeetingJoined(const CMR_MeetingData & info);
		virtual void OnCMRMeetingFailed(int nErrorCode);
		virtual void OnCMRMeetingEnded();

		void networkChanged(bool bConnected);

	private:
		CMRMeetingData createCMRMeetingData(const CMR_MeetingData& meetingData);

	private:
		void ConvertMeetingReminderInfo2Object(const JabberMeeting::MeetingReminderItem &objMeetingReminderItem, MeetingReminderInfoBaseImpl &obj);
		void ConvertMeetingIMAlertItem2Object(const JabberMeeting::MeetingIMAlertItem &objItem, MeetingIMAlertItemObjectBaseImpl & obj);

		void ConvertSystemTimeToMeetingTime(const SYSTEMTIME& sysTime, MeetingTimeBaseImpl* pMeetingTime);

	private:
		SMART_PTR_NS::shared_ptr<UnifiedFactory> m_unifiedFactory;
		bool started;

		csf::RWLock mLock;
		JabberMeeting::JMMeetingMgr* m_pMeetingMgr;
		IInstantMeetingMgr * m_pIMMgr;
		MeetingCallback* m_meetingCallback;
    };
    
}

#endif

#endif